package gov.va.genisis2.converter;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

import gov.va.genisis2.dto.RequestHistoryDTO;
import gov.va.genisis2.model.CommentHistory;
import gov.va.genisis2.model.Request;
import gov.va.genisis2.model.RequestHistory;

/**
 * This class is used to convert RequestHistoryDTO to RequestHistory entity and vice-versa.
 * 
 * @author Prasad Thummalapalli
 *
 */
@Component
public class RequestHistoryConverter implements Converter<RequestHistory, RequestHistoryDTO> {

	@Autowired
	private CommentHistoryConverter commentHistoryConverter;
	
	@Override
	public RequestHistoryDTO convert(RequestHistory requestHistory) {
		RequestHistoryDTO requestHistoryDto = new RequestHistoryDTO();

		requestHistoryDto.setHistLineNo(requestHistory.getHistLineNo());
		requestHistoryDto.setRequestId(requestHistory.getRequestId());
		requestHistoryDto.setProcessId(requestHistory.getProcessId());
		requestHistoryDto.setTitle(requestHistory.getTitle());
		requestHistoryDto.setDescription(requestHistory.getDescription());
		requestHistoryDto.setStatusDescription(requestHistory.getStatusDescription());
		requestHistoryDto.setRequestTypeId(requestHistory.getRequestTypeId());
		requestHistoryDto.setSourceId(requestHistory.getSourceId());
		requestHistoryDto.setStudyApprovalId(requestHistory.getStudyApprovalId());
		requestHistoryDto.setCreatedOn(requestHistory.getCreatedOn());
		requestHistoryDto.setModifiedOn(requestHistory.getModifiedOn());
		requestHistoryDto.setCreatedBy(requestHistory.getCreatedBy());
		requestHistoryDto.setModifiedBy(requestHistory.getModifiedBy());
		requestHistoryDto.setApproverId(requestHistory.getApproverId());
		requestHistoryDto.setTaskId(requestHistoryDto.getTaskId());

		return requestHistoryDto;
	}

	public RequestHistory convert(RequestHistoryDTO requestHistoryDto) {
		RequestHistory requestHistory = new RequestHistory();

		requestHistory.setHistLineNo(requestHistoryDto.getHistLineNo());
		requestHistory.setRequestId(requestHistoryDto.getRequestId());
		requestHistory.setProcessId(requestHistoryDto.getProcessId());
		requestHistory.setTitle(requestHistoryDto.getTitle());
		requestHistory.setDescription(requestHistoryDto.getDescription());
		requestHistory.setStatusDescription(requestHistoryDto.getStatusDescription());
		requestHistory.setSourceId(requestHistoryDto.getSourceId());
		requestHistory.setRequestTypeId(requestHistoryDto.getRequestTypeId());
		requestHistory.setStudyApprovalId(requestHistoryDto.getStudyApprovalId());
		requestHistory.setCreatedOn(requestHistoryDto.getCreatedOn());
		requestHistory.setModifiedOn(requestHistoryDto.getModifiedOn());
		requestHistory.setCreatedBy(requestHistoryDto.getCreatedBy());
		requestHistory.setModifiedBy(requestHistoryDto.getModifiedBy());
		requestHistory.setApproverId(requestHistoryDto.getApproverId());
		requestHistory.setTaskId(requestHistoryDto.getTaskId());

		return requestHistory;
	}

	public Set<RequestHistoryDTO> convertRequestHistories(Set<RequestHistory> requestHistories) {
		Set<RequestHistoryDTO> requestHistoryDtos = null;
		if (!requestHistories.isEmpty()) {
			requestHistoryDtos = new HashSet<>();
			for (RequestHistory requestHistory : requestHistories) {
				requestHistoryDtos.add(convert(requestHistory));
			}
		}

		return requestHistoryDtos;
	}
	
	public RequestHistoryDTO convert(RequestHistory requestHistory, List<CommentHistory> commentHistories) {
		RequestHistoryDTO requestHistoryDto = convert(requestHistory);
		
		if (null != commentHistories && !commentHistories.isEmpty()) {
			requestHistoryDto.setCommentHistory(commentHistoryConverter.convertCommentHistories(commentHistories));
		}
		
		return requestHistoryDto;
	}

	public RequestHistory populateRequestHistory(Request request) {
		RequestHistory requestHistory = new RequestHistory();

		requestHistory.setHistLineNo(0);
		requestHistory.setRequestId(request.getId());
		requestHistory.setRequest(request);
		requestHistory.setProcessId(request.getProcessId());
		requestHistory.setTitle(request.getTitle());
		requestHistory.setDescription(request.getDescription());
		requestHistory.setStatusDescription(request.getStatusDescription());
		requestHistory.setRequestTypeId(request.getRequestTypeId());
		requestHistory.setSourceId(request.getSourceId());
		requestHistory.setStudyApprovalId(request.getStudyApprovalId());
		requestHistory.setCreatedOn(request.getCreatedOn());
		requestHistory.setModifiedOn(request.getModifiedOn());
		requestHistory.setCreatedBy(request.getCreatedBy());
		requestHistory.setModifiedBy(request.getModifiedBy());
		requestHistory.setApproverId(request.getApproverId());
		requestHistory.setTaskId(request.getTaskId());

		return requestHistory;
	}
}